# Reaches around 0.7870 ± 0.0036 test accuracy.

import os.path as osp
import numpy as np
import torch
import torch.nn.functional as F
from ogb.nodeproppred import Evaluator, PygNodePropPredDataset
from tqdm import tqdm
from torch_geometric.nn.conv.gcn_conv import gcn_norm
from torch_geometric.loader import NeighborLoader
from torch_geometric.nn import SAGEConv,GCNConv

device = torch.device('cuda:0' if torch.cuda.is_available() else 'cpu')
root = osp.join(osp.dirname(osp.realpath(__file__)), '..', 'data', 'products')
dataset = PygNodePropPredDataset('ogbn-products', root)
split_idx = dataset.get_idx_split()
evaluator = Evaluator(name='ogbn-products')
data = dataset[0].to(device, 'x', 'y')

# device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
# root = osp.join(osp.dirname(osp.realpath(__file__)), '..', 'data', 'arxiv')
# dataset = PygNodePropPredDataset('ogbn-arxiv', root)
# split_idx = dataset.get_idx_split()
# evaluator = Evaluator(name='ogbn-arxiv')
# data = dataset[0].to(device, 'x', 'y')

train_loader = NeighborLoader(
    data,
    input_nodes=split_idx['train'],
    num_neighbors=[15, 10, 5],
    batch_size=512,
    shuffle=True,
    num_workers=12,
    persistent_workers=True,
)
subgraph_loader = NeighborLoader(
    data,
    input_nodes=None,
    num_neighbors=[-1],
    batch_size=512,
    num_workers=12,
    persistent_workers=True,
)


class SAGE(torch.nn.Module):
    def __init__(self, in_channels, hidden_channels, out_channels, num_layers):
        super().__init__()

        self.num_layers = num_layers

        self.convs = torch.nn.ModuleList()
        self.convs.append(SAGEConv(in_channels, hidden_channels))
        for _ in range(num_layers - 2):
            self.convs.append(SAGEConv(hidden_channels, hidden_channels))
        self.convs.append(SAGEConv(hidden_channels, out_channels))

    def reset_parameters(self):
        for conv in self.convs:
            conv.reset_parameters()

    def forward(self, x, edge_index):
        for i, conv in enumerate(self.convs):
            h = x
            x = conv(x, edge_index)
            if i != self.num_layers - 1:
                x = x.relu()
                x = F.dropout(x, p=0.5, training=self.training)
        return x

    def inference(self, x_all):
        pbar = tqdm(total=x_all.size(0) * self.num_layers)
        pbar.set_description('Evaluating')

        # Compute representations of nodes layer by layer, using *all*
        # available edges. This leads to faster computation in contrast to
        # immediately computing the final representations of each batch.
        for i in range(self.num_layers):
            xs = []
            for batch in subgraph_loader:
                x = x_all[batch.n_id].to(device)
                edge_index = batch.edge_index.to(device)
                x = self.convs[i](x, edge_index)
                x = x[:batch.batch_size]
                if i != self.num_layers - 1:
                    x = x.relu()
                xs.append(x.cpu())

                pbar.update(batch.batch_size)

            x_all = torch.cat(xs, dim=0)

        pbar.close()

        return x_all


class GCN_res(torch.nn.Module):
    def __init__(self, in_channels, hidden_channels, out_channels, num_layers):
        super().__init__()

        self.num_layers = num_layers

        self.convs = torch.nn.ModuleList()
        self.convs.append(SAGEConv(in_channels, hidden_channels))
        for _ in range(num_layers - 1):
            self.convs.append(SAGEConv(hidden_channels, hidden_channels))
        # self.convs.append(SAGEConv(hidden_channels, out_channels))
        
        self.out_fc = torch.nn.Linear(hidden_channels, out_channels)
        self.weights = torch.nn.Parameter(torch.randn((len(self.convs))))
        
    def reset_parameters(self):
        for conv in self.convs:
            conv.reset_parameters()
        self.out_fc.reset_parameters()
        torch.nn.init.normal_(self.weights)
            
    def forward(self, x, edge_index):
        edge_index1 = sampling(edge_index,p1_sampling)
        edge_index2 = sampling(edge_index,p2_sampling)
        layer_out = []
        for i, conv in enumerate(self.convs):
            if i < self.num_layers/2:
                x = conv(x, edge_index1)
            else:
                x = conv(x, edge_index2)
            # if i != self.num_layers - 1:
            x = x.relu()
            x = F.dropout(x, p=0.5, training=self.training)
            layer_out.append(x)
            
        weight = F.softmax(self.weights, dim=0)
        for i in range(len(layer_out)):
            layer_out[i] = layer_out[i] * weight[i]
        x = sum(layer_out)
        x = self.out_fc(x)
        return x


    def inference(self, x_all):
        pbar = tqdm(total=x_all.size(0) * self.num_layers)
        pbar.set_description('Evaluating')
        layer_out = []
        # Compute representations of nodes layer by layer, using *all*
        # available edges. This leads to faster computation in contrast to
        # immediately computing the final representations of each batch.
        for i in range(self.num_layers):
            xs = []
            for batch in subgraph_loader:
                x = x_all[batch.n_id].to(device)
                edge_index = batch.edge_index.to(device)
                x = self.convs[i](x, edge_index)
                x = x[:batch.batch_size]
                # if i != self.num_layers - 1:
                x = x.relu()
                xs.append(x.cpu())

                pbar.update(batch.batch_size)

            x_all = torch.cat(xs, dim=0)
            layer_out.append(x_all)
            
        weight = F.softmax(self.weights, dim=0)
        for i in range(len(layer_out)):
            layer_out[i] = layer_out[i] * weight[i].cpu()
        x_all = sum(layer_out)
        x_all = x_all.to(device)
        x_all = self.out_fc(x_all)
        pbar.close()

        return x_all

num_layers = 4
model = GCN_res(dataset.num_features, 128, dataset.num_classes, num_layers=num_layers)
model = model.to(device)

def sampling(edge_index,p_sampling):
    # p_random = 0.1
    norm_edge, norm_value = gcn_norm(edge_index, add_self_loops=False)
    num_values_to_keep = int(norm_value.numel() * p_sampling) #sample less 0.5
    num_values_to_delete = norm_value.numel() - num_values_to_keep
    k=num_values_to_keep
    top_values, top_indices = torch.topk(norm_value, k=num_values_to_keep)
    other_indices = torch.nonzero(torch.lt(norm_value, top_values[k-1])).squeeze()
    
    if num_values_to_keep>=num_values_to_delete:
        num_values_to_random = int(num_values_to_delete*p_random)+1
    
        random_indices = torch.randperm(len(top_indices))[:-num_values_to_random]
        top_indices = top_indices[random_indices]
    
        random_indices = torch.randperm(len(other_indices))[:num_values_to_random]
        other_indices = other_indices[random_indices]

        choose_indices = torch.cat((top_indices, other_indices))
    else:
        num_values_to_random = int(num_values_to_keep*p_random)+1
    
        random_indices = torch.randperm(len(top_indices))[:-num_values_to_random]
        top_indices = top_indices[random_indices]
    
        random_indices = torch.randperm(len(other_indices))[:num_values_to_random]
        other_indices = other_indices[random_indices]

        choose_indices = torch.cat((top_indices, other_indices))
        
    edge_index = norm_edge[:,choose_indices]
    return edge_index


def train(epoch):
    model.train()

    pbar = tqdm(total=split_idx['train'].size(0))
    pbar.set_description(f'Epoch {epoch:02d}')

    total_loss = total_correct = 0
    for batch in train_loader:
        optimizer.zero_grad()
        out = model(batch.x, batch.edge_index.to(device))[:batch.batch_size]
        y = batch.y[:batch.batch_size].squeeze()
        loss = F.cross_entropy(out, y)
        loss.backward()
        optimizer.step()

        total_loss += float(loss)
        total_correct += int(out.argmax(dim=-1).eq(y).sum())
        pbar.update(batch.batch_size)

    pbar.close()

    loss = total_loss / len(train_loader)
    approx_acc = total_correct / split_idx['train'].size(0)

    return loss, approx_acc


@torch.no_grad()
def test():
    model.eval()

    out = model.inference(data.x)

    y_true = data.y.cpu()
    y_pred = out.argmax(dim=-1, keepdim=True)

    # train_acc = evaluator.eval({
    #     'y_true': y_true[split_idx['train']],
    #     'y_pred': y_pred[split_idx['train']],
    # })['acc']
    # val_acc = evaluator.eval({
    #     'y_true': y_true[split_idx['valid']],
    #     'y_pred': y_pred[split_idx['valid']],
    # })['acc']
    test_acc = evaluator.eval({
        'y_true': y_true[split_idx['test']],
        'y_pred': y_pred[split_idx['test']],
    })['acc']
    train_acc = 0
    val_acc = 0
    return train_acc, val_acc, test_acc

epochs = 80
test_accs = []
p_random = 0.1
runs = 1
p1_sampling_values = np.arange(1, 0.09, -1.1)
p2_sampling_values = np.arange(0.1, 1.01, 1)
for p2_sampling in p2_sampling_values:
        for p1_sampling in p1_sampling_values:
            
            print(p1_sampling, p2_sampling)
            run_test_accs = [[] for _ in range(runs)]
            run_train_accs = [[] for _ in range(runs)]
            for run in range(runs):
                print(f'\nRun {run:02d}:\n')

                model.reset_parameters()
                optimizer = torch.optim.Adam(model.parameters(), lr=0.003)

                best_val_acc = final_test_acc = 0
                for epoch in range(epochs):
                    # train_acc, val_acc, test_acc = test()
                    loss, acc = train(epoch)
                    run_train_accs.append(acc)
                    print(f'Epoch {epoch:02d}, Loss: {loss:.4f}, Approx. Train: {acc:.4f}')

                    if epoch > epochs-6:
                        train_acc, val_acc, test_acc = test()
                        run_test_accs[run].append(test_acc)
                        print(f'Train: {train_acc:.4f}, Val: {val_acc:.4f}, '
                            f'Test: {test_acc:.4f}')

                        if val_acc > best_val_acc:
                            best_val_acc = val_acc
                            final_test_acc = test_acc
                test_accs.append(final_test_acc)

            test_acc = torch.tensor(test_accs)
            # print('============================')
            # print(f'Final Test: {test_acc.mean():.4f} ± {test_acc.std():.4f}')
            
            np.save(f'examples/ogbn-products_output1/50-test-{num_layers}-{p_random}: runs={runs} p1={p1_sampling:.1f} p2={p2_sampling:.1f}.npy',run_test_accs)
            np.save(f'examples/ogbn-products_output1/50-train-{num_layers}-{p_random}: runs={runs} p1={p1_sampling:.1f} p2={p2_sampling:.1f}.npy',run_train_accs)



